// 配置文件
const CONFIG = {
  // 后台服务地址
  SERVICE_URL: 'http://115.190.230.181:3005',

  // API端点
  API: {
    CONVERT_TO_IMAGE: '/api/convert/image',
    CONVERT_TO_PDF: '/api/convert/pdf'
  },

  // 选择器配置 - 用于定位AI Studio页面元素
  SELECTORS: {
    // 对话消息容器
    MESSAGE_TURN: 'ms-chat-turn',
    // 菜单容器
    MENU_CONTENT: '.mat-mdc-menu-content',
    // 更多选项按钮
    MORE_OPTIONS_BUTTON: 'ms-chat-turn-options button',
    // 消息内容
    MESSAGE_CONTENT: '.turn-content'
  },

  // 导出选项
  EXPORT_OPTIONS: {
    IMAGE: {
      format: 'png',
      quality: 0.95,
      backgroundColor: '#ffffff'
    },
    PDF: {
      format: 'A4',
      printBackground: true,
      margin: {
        top: '20px',
        right: '20px',
        bottom: '20px',
        left: '20px'
      }
    }
  }
};

// 导出配置（支持在content script和background script中使用）
if (typeof module !== 'undefined' && module.exports) {
  module.exports = CONFIG;
}
