// Popup页面脚本
document.addEventListener('DOMContentLoaded', () => {
  // 设置服务地址
  document.getElementById('serviceUrl').value = 'http://115.190.230.181:3005';
  checkServiceStatus();
});

// 检查后台服务状态
async function checkServiceStatus() {
  const statusEl = document.getElementById('status');
  const serviceUrl = document.getElementById('serviceUrl').value;

  try {
    const response = await fetch(`${serviceUrl}/api/health`, {
      method: 'GET',
      signal: AbortSignal.timeout(3000) // 3秒超时
    });

    if (response.ok) {
      statusEl.className = 'status';
      statusEl.querySelector('.status-text').textContent = '服务正常运行';
    } else {
      throw new Error('服务响应异常');
    }
  } catch (error) {
    statusEl.className = 'status error';
    statusEl.querySelector('.status-text').textContent = '服务未连接';
    console.error('服务状态检查失败:', error);
  }
}
